/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.entity.ChainLinkEntity;
import com.github.legoatoom.connectiblechains.entity.Chainable;
import com.github.legoatoom.connectiblechains.entity.ModEntityTypes;
import com.github.legoatoom.connectiblechains.util.Helper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainCollisionEntity
extends class_1297
implements ChainLinkEntity {
    private static final float COLLIDER_SPACING = 1.5f;
    @Nullable
    private Chainable.ChainData link;
    private class_1297 chainedEntity;
    @NotNull
    private class_1792 linkSourceItem;

    public ChainCollisionEntity(class_1937 world, double x, double y, double z, class_1297 chainedEntity, @NotNull Chainable.ChainData link) {
        this(ModEntityTypes.CHAIN_COLLISION, world);
        this.link = link;
        this.method_5814(x, y, z);
        this.linkSourceItem = link.sourceItem;
        this.chainedEntity = chainedEntity;
    }

    public ChainCollisionEntity(class_1299<? extends ChainCollisionEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static <E extends class_1297> void createCollision(E chainedEntity, Chainable.ChainData chainData) {
        double step;
        if (!chainData.collisionStorage.isEmpty()) {
            return;
        }
        if (chainedEntity.method_37908().method_8608()) {
            return;
        }
        class_1297 chainHolder = ((Chainable)chainedEntity).getChainHolder(chainData);
        if (chainHolder == null) {
            return;
        }
        double distance = chainedEntity.method_5739(chainHolder);
        double centerHoldout = (double)ModEntityTypes.CHAIN_COLLISION.method_17685() / distance;
        for (double v = step = 1.5 * Math.sqrt(Math.pow(ModEntityTypes.CHAIN_COLLISION.method_17685(), 2.0) * 2.0) / distance; v < 0.5 - centerHoldout; v += step) {
            ChainCollisionEntity collider2;
            ChainCollisionEntity collider1 = ChainCollisionEntity.spawnCollision(false, chainedEntity, chainData, v);
            if (collider1 != null) {
                chainData.collisionStorage.add(collider1.method_5628());
            }
            if ((collider2 = ChainCollisionEntity.spawnCollision(true, chainedEntity, chainData, v)) == null) continue;
            chainData.collisionStorage.add(collider2.method_5628());
        }
        ChainCollisionEntity centerCollider = ChainCollisionEntity.spawnCollision(false, chainedEntity, chainData, 0.5);
        if (centerCollider != null) {
            chainData.collisionStorage.add(centerCollider.method_5628());
        }
    }

    public static <E extends class_1297> ChainCollisionEntity spawnCollision(boolean reverse, E chainedEntity, Chainable.ChainData chainData, double distancePercentage) {
        class_243 dstPos;
        class_1937 class_19372 = chainedEntity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_1297 chainHolder = ((Chainable)chainedEntity).getChainHolder(chainData);
        assert (chainHolder != null);
        class_243 srcPos = ((Chainable)chainedEntity).getChainPos(1.0f);
        if (chainHolder instanceof ChainKnotEntity) {
            ChainKnotEntity chainKnotEntity = (ChainKnotEntity)chainHolder;
            dstPos = chainKnotEntity.getChainPos(1.0f);
        } else {
            dstPos = chainHolder.method_30951(1.0f);
        }
        class_243 tmp = dstPos;
        if (reverse) {
            dstPos = srcPos;
            srcPos = tmp;
        }
        double distance = srcPos.method_1022(dstPos);
        double x = class_3532.method_16436((double)distancePercentage, (double)srcPos.method_10216(), (double)dstPos.method_10216());
        double y = srcPos.method_10214() + Helper.drip2(distancePercentage * distance, distance, dstPos.method_10214() - srcPos.method_10214());
        double z = class_3532.method_16436((double)distancePercentage, (double)srcPos.method_10215(), (double)dstPos.method_10215());
        ChainCollisionEntity c = new ChainCollisionEntity((class_1937)serverWorld, x, y += (double)(-ModEntityTypes.CHAIN_COLLISION.method_17686() + 0.125f), z, chainedEntity, chainData);
        if (serverWorld.method_8649((class_1297)c)) {
            return c;
        }
        ConnectibleChains.LOGGER.warn("Tried to summon collision entity for a chain, failed to do so");
        return null;
    }

    public static void destroyCollision(class_3218 world, Chainable.ChainData chainData) {
        for (Integer entityId : chainData.collisionStorage) {
            class_1297 e = world.method_8469(entityId.intValue());
            if (e instanceof ChainCollisionEntity) {
                e.method_31472();
                continue;
            }
            if (e == null) continue;
            ConnectibleChains.LOGGER.warn("Collision storage contained reference to {} (#{}) which is not a collision entity.", (Object)e, (Object)entityId);
        }
    }

    @Nullable
    public Chainable.ChainData getLink() {
        return this.link;
    }

    @NotNull
    public class_1792 getLinkSourceItem() {
        return this.linkSourceItem;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5810() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_24520(itemStack -> itemStack.method_31573(ConventionalItemTags.SHEAR_TOOLS))) {
            return super.method_5640(distance);
        }
        return false;
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5698(class_1297 attacker) {
        if (!super.method_5698(attacker)) {
            this.method_5783(Chainable.getSourceBlockSoundGroup(this.getLinkSourceItem()).method_10596(), 0.5f, 1.0f);
        }
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236) {
            return false;
        }
        assert (this.getLink() != null);
        class_1269 result = this.onDamageFrom(source, Chainable.getSourceBlockSoundGroup(this.getLinkSourceItem()).method_10596());
        if (!result.method_23665()) {
            return false;
        }
        class_1297 class_12972 = this.chainedEntity;
        if (class_12972 instanceof Chainable) {
            Chainable chainable = (Chainable)class_12972;
            ConnectibleChains.LOGGER.debug("Dropping chain ({}) due to receiving damage from source: {}", (Object)this.getLink(), (Object)source);
            chainable.detachChain(this.getLink());
        }
        return true;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5998(hand).method_31573(ConventionalItemTags.SHEAR_TOOLS)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        int id = class_7923.field_41178.method_10206((Object)this.linkSourceItem);
        return new class_2604((class_1297)this, entityTrackerEntry, id);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        int rawChainItemSourceId = packet.method_11166();
        this.linkSourceItem = (class_1792)class_7923.field_41178.method_10200(rawChainItemSourceId);
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.linkSourceItem);
    }
}

