/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.entity;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.entity.ChainCollisionEntity;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.networking.packet.ChainAttachS2CPacket;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1804;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_7923;
import net.minecraft.class_9691;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Chainable {
    public static final String CHAINS_NBT_KEY = "Chains";
    public static final String SOURCE_ITEM_KEY = "SourceItem";

    public static double getMaxChainLength() {
        return ConnectibleChains.runtimeConfig.getMaxChainRange();
    }

    private static <E extends class_9691> boolean canAttachTo(E entity, class_1297 potentialHolder) {
        if (((Chainable)entity).getChainData(potentialHolder) != null) {
            return false;
        }
        if (potentialHolder instanceof Chainable) {
            Chainable chainable = (Chainable)potentialHolder;
            return !entity.equals((Object)potentialHolder) && chainable.getChainData((class_1297)entity) == null;
        }
        return false;
    }

    private static <E extends class_9691> HashSet<ChainData> readChainDataSet(E entity, class_2487 nbt) {
        HashSet<ChainData> result = new HashSet<ChainData>();
        if (nbt.method_10573(CHAINS_NBT_KEY, 9)) {
            class_2499 list = nbt.method_10554(CHAINS_NBT_KEY, 10);
            for (class_2520 element : list) {
                if (!(element instanceof class_2487)) continue;
                class_2487 compound = (class_2487)element;
                ChainData newChainData = null;
                class_1792 source = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)compound.method_10558(SOURCE_ITEM_KEY)));
                if (compound.method_25928("UUID")) {
                    newChainData = new ChainData((Either<UUID, class_2338>)Either.left((Object)compound.method_25926("UUID")), source);
                } else if (compound.method_10545("DestX")) {
                    Either either = Either.right((Object)new class_2338(compound.method_10550("DestX"), compound.method_10550("DestY"), compound.method_10550("DestZ")));
                    newChainData = new ChainData((Either<UUID, class_2338>)either, source);
                } else if (compound.method_10545("RelX")) {
                    class_2338 relPos = new class_2338(compound.method_10550("RelX"), compound.method_10550("RelY"), compound.method_10550("RelZ"));
                    class_2338 desPos = relPos.method_10081((class_2382)entity.method_59940());
                    newChainData = new ChainData((Either<UUID, class_2338>)Either.right((Object)desPos), source);
                }
                if (newChainData == null) continue;
                result.add(newChainData);
            }
        }
        return result;
    }

    private static <E extends class_9691> void resolveChainDataSet(E entity, HashSet<ChainData> chainDataSet) {
        class_1937 class_19372 = entity.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        for (ChainData chainData : new HashSet<ChainData>(chainDataSet)) {
            Object chainHolder;
            if (chainData.unresolvedChainData == null) continue;
            Optional optionalUUID = chainData.unresolvedChainData.left();
            Optional optionalBlockPos = chainData.unresolvedChainData.right();
            if (optionalUUID.isPresent()) {
                chainHolder = serverWorld.method_14190((UUID)optionalUUID.get());
                if (chainHolder != null) {
                    newChainData = new ChainData((class_1297)chainHolder, chainData.sourceItem);
                    ((Chainable)entity).replaceChainData(chainData, null);
                    Chainable.attachChain(entity, newChainData, null, true);
                    continue;
                }
            } else if (optionalBlockPos.isPresent() && (chainHolder = ChainKnotEntity.getOrNull((class_1937)serverWorld, (class_2338)optionalBlockPos.get())) != null) {
                newChainData = new ChainData((class_1297)chainHolder, chainData.sourceItem);
                ((Chainable)entity).replaceChainData(chainData, null);
                Chainable.attachChain(entity, newChainData, null, true);
                continue;
            }
            if (entity.field_6012 <= 100) continue;
            ConnectibleChains.LOGGER.debug("Dropping chain connection as we have not been able to find chainholder for {}", (Object)chainData);
            entity.method_5706((class_1935)chainData.sourceItem);
            ((Chainable)entity).replaceChainData(chainData, null);
        }
    }

    private static <E extends class_9691> void detachChain(E entity, ChainData chainData, boolean sendPacket, boolean dropItem) {
        if (chainData.chainHolder != null && chainData.isAlive()) {
            chainData.kill();
            ((Chainable)entity).replaceChainData(chainData, null);
            ((Chainable)entity).onChainDetached(chainData);
            class_1937 class_19372 = entity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (dropItem) {
                    entity.method_5706((class_1935)chainData.sourceItem);
                }
                if (sendPacket) {
                    serverWorld.method_14178().method_18754(entity, new ChainAttachS2CPacket((class_1297)entity, chainData.chainHolder, null, chainData.sourceItem).asPacket());
                }
                ChainCollisionEntity.destroyCollision(serverWorld, chainData);
            }
        }
    }

    private static <E extends class_9691> void attachChain(E entity, ChainData chainData, @Nullable class_1297 previousHolder, boolean sendPacket) {
        class_1937 class_19372;
        if (chainData.chainHolder == null) {
            throw new IllegalArgumentException("Given chainData has empty holder");
        }
        ((Chainable)entity).replaceChainData(((Chainable)entity).getChainData(previousHolder), chainData);
        ((Chainable)entity).onChainAttached(chainData);
        if (sendPacket && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14178().method_18754(entity, new ChainAttachS2CPacket((class_1297)entity, previousHolder, chainData.chainHolder, chainData.sourceItem).asPacket());
            if (chainData.chainHolder instanceof Chainable) {
                ChainCollisionEntity.createCollision(entity, chainData);
            }
        }
    }

    public static <E extends class_9691> void tickChain(class_3218 world, E entity) {
        HashSet<ChainData> chainDataSet = ((Chainable)entity).getChainDataSet();
        Chainable.resolveChainDataSet(entity, chainDataSet);
        for (ChainData chainData : new HashSet<ChainData>(chainDataSet)) {
            float distanceTo;
            class_1297 chainHolder = ((Chainable)entity).getChainHolder(chainData);
            if (chainHolder == null) continue;
            if (!entity.method_5805() || !chainHolder.method_5805()) {
                if (!entity.method_5805()) {
                    ConnectibleChains.LOGGER.debug("Removing chain since chainReceiver ({}) is no longer alive, data: {}", entity, (Object)chainData);
                } else {
                    ConnectibleChains.LOGGER.debug("Removing chain since chainHolder ({}) is no longer alive, data: {}", (Object)chainHolder, (Object)chainData);
                }
                if (world.method_8450().method_8355(class_1928.field_19393)) {
                    ((Chainable)entity).detachChain(chainData);
                } else {
                    ((Chainable)entity).detachChainWithoutDrop(chainData);
                }
            }
            if ((chainHolder = ((Chainable)entity).getChainHolder(chainData)) == null || !chainHolder.method_37908().equals(entity.method_37908()) || !((Chainable)entity).beforeChainTick(chainHolder, distanceTo = entity.method_5739(chainHolder)) || !((double)distanceTo > Chainable.getMaxChainLength())) continue;
            ((Chainable)entity).breakLongChain(chainData);
        }
    }

    @Nullable
    private static <E extends class_9691> class_1297 getChainHolder(E entity, ChainData chainData) {
        class_1297 chainHolder;
        if (!((Chainable)entity).getChainDataSet().contains(chainData)) {
            return null;
        }
        if (chainData.unresolvedChainHolderId != 0 && entity.method_37908().field_9236 && (chainHolder = entity.method_37908().method_8469(chainData.unresolvedChainHolderId)) instanceof class_1297) {
            ((Chainable)entity).replaceChainData(chainData, new ChainData(chainHolder, chainData.sourceItem));
        }
        return chainData.chainHolder;
    }

    public static class_2498 getSourceBlockSoundGroup(class_1792 sourceItem) {
        class_1792 class_17922 = sourceItem;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1747.class, class_1804.class}, (Object)class_17922, n)) {
            case 0 -> {
                class_1747 blockItem = (class_1747)class_17922;
                yield blockItem.method_7711().method_9564().method_26231();
            }
            case 1 -> {
                class_1804 ignored = (class_1804)class_17922;
                yield new class_2498(1.0f, 1.0f, class_3417.field_15184, class_2498.field_11543.method_10594(), class_3417.field_15062, class_2498.field_11543.method_10596(), class_2498.field_11543.method_10593());
            }
            default -> class_2498.field_24119;
        };
    }

    default public boolean canAttachTo(class_1297 entity) {
        return Chainable.canAttachTo((class_9691)this, entity);
    }

    public HashSet<ChainData> getChainDataSet();

    public void replaceChainData(@Nullable ChainData var1, @Nullable ChainData var2);

    public void setChainData(HashSet<ChainData> var1);

    default public void addUnresolvedChainHolderId(int unresolvedOldChainHolderId, int unresolvedNewChainHolderId, class_1792 sourceItem) {
        ChainData oldChainData = null;
        ChainData newChainData = null;
        if (unresolvedOldChainHolderId != 0) {
            oldChainData = new ChainData(unresolvedOldChainHolderId, sourceItem);
        }
        if (unresolvedNewChainHolderId != 0) {
            newChainData = new ChainData(unresolvedNewChainHolderId, sourceItem);
        }
        this.replaceChainData(oldChainData, newChainData);
    }

    default public void readChainDataFromNbt(class_2487 nbt) {
        this.setSourceItem((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)nbt.method_10558(SOURCE_ITEM_KEY))));
        HashSet<ChainData> chainData = Chainable.readChainDataSet((class_9691)this, nbt);
        if (!this.getChainDataSet().isEmpty() && chainData.isEmpty()) {
            this.detachAllChainsWithoutDrop();
        }
        this.setChainData(chainData);
    }

    default public void writeChainDataSetToNbt(class_2487 nbt, HashSet<ChainData> chainDataSet) {
        nbt.method_10582(SOURCE_ITEM_KEY, class_7923.field_41178.method_10221((Object)this.getSourceItem()).toString());
        class_2499 linksTag = new class_2499();
        for (ChainData chainData : chainDataSet) {
            Either either = chainData.unresolvedChainData;
            class_1297 class_12972 = chainData.chainHolder;
            if (class_12972 instanceof ChainKnotEntity) {
                ChainKnotEntity chainKnotEntity = (ChainKnotEntity)class_12972;
                either = Either.right((Object)chainKnotEntity.method_59940());
            } else if (chainData.chainHolder != null) {
                either = Either.left((Object)chainData.chainHolder.method_5667());
            }
            if (either == null) continue;
            String sourceItem = class_7923.field_41178.method_10221((Object)chainData.sourceItem).toString();
            linksTag.add((Object)((class_2520)either.map(uuid -> {
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_25927("UUID", uuid);
                nbtCompound.method_10582(SOURCE_ITEM_KEY, sourceItem);
                return nbtCompound;
            }, blockPos -> {
                class_2487 nbtCompound = new class_2487();
                nbtCompound.method_10569("DestX", blockPos.method_10263());
                nbtCompound.method_10569("DestY", blockPos.method_10264());
                nbtCompound.method_10569("DestZ", blockPos.method_10260());
                nbtCompound.method_10582(SOURCE_ITEM_KEY, sourceItem);
                return nbtCompound;
            })));
        }
        if (!linksTag.isEmpty()) {
            nbt.method_10566(CHAINS_NBT_KEY, (class_2520)linksTag);
        }
    }

    default public void detachChain(ChainData chainData) {
        Chainable.detachChain((class_9691)this, chainData, true, true);
    }

    default public void detachChainWithoutDrop(ChainData chainData) {
        Chainable.detachChain((class_9691)this, chainData, true, false);
    }

    default public void detachAllChains() {
        for (ChainData chainData : new HashSet<ChainData>(this.getChainDataSet())) {
            this.detachChain(chainData);
        }
    }

    default public void detachAllChainsWithoutDrop() {
        for (ChainData chainData : new HashSet<ChainData>(this.getChainDataSet())) {
            this.detachChainWithoutDrop(chainData);
        }
    }

    default public void onChainDetached(ChainData removedChainData) {
    }

    default public boolean beforeChainTick(class_1297 chainHolder, float distance) {
        return true;
    }

    default public void breakLongChain(ChainData chainData) {
        ConnectibleChains.LOGGER.debug("Breaking chain as it is too long! {}", (Object)chainData);
        this.detachChain(chainData);
    }

    default public void attachChain(ChainData chainData, @Nullable class_1297 previousHolder, boolean sendPacket) {
        Chainable.attachChain((class_9691)this, chainData, previousHolder, sendPacket);
    }

    default public void onChainAttached(ChainData newChainData) {
    }

    @Nullable
    default public class_1297 getChainHolder(ChainData chainData) {
        return Chainable.getChainHolder((class_9691)this, chainData);
    }

    @Nullable
    default public ChainData getChainData(@Nullable class_1297 holder) {
        if (holder != null) {
            for (ChainData chainData : new HashSet<ChainData>(this.getChainDataSet())) {
                if (this.getChainHolder(chainData) != holder) continue;
                return chainData;
            }
        }
        return null;
    }

    public class_1792 getSourceItem();

    public void setSourceItem(class_1792 var1);

    default public class_2498 getSourceBlockSoundGroup() {
        return Chainable.getSourceBlockSoundGroup(this.getSourceItem());
    }

    public class_243 getChainPos(float var1);

    public static final class ChainData {
        private boolean isDead = false;
        public final ArrayList<Integer> collisionStorage = new ArrayList(16);
        @Nullable
        public final Either<UUID, class_2338> unresolvedChainData;
        @NotNull
        public final class_1792 sourceItem;
        final int unresolvedChainHolderId;
        @Nullable
        private final class_1297 chainHolder;

        public ChainData(@Nullable Either<UUID, class_2338> unresolvedChainData, @NotNull class_1792 sourceItem) {
            this.unresolvedChainData = unresolvedChainData;
            this.sourceItem = sourceItem;
            this.chainHolder = null;
            this.unresolvedChainHolderId = 0;
        }

        public ChainData(@Nullable class_1297 chainHolder, @NotNull class_1792 sourceItem) {
            this.chainHolder = chainHolder;
            this.sourceItem = sourceItem;
            this.unresolvedChainData = null;
            this.unresolvedChainHolderId = 0;
        }

        public ChainData(int unresolvedChainHolderId, @NotNull class_1792 sourceItem) {
            this.unresolvedChainHolderId = unresolvedChainHolderId;
            this.sourceItem = sourceItem;
            this.chainHolder = null;
            this.unresolvedChainData = null;
        }

        public class_2498 getSourceBlockSoundGroup() {
            return Chainable.getSourceBlockSoundGroup(this.sourceItem);
        }

        private int getHolderId() {
            return this.chainHolder != null ? this.chainHolder.method_5628() : this.unresolvedChainHolderId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ChainData)) {
                return false;
            }
            ChainData chainData = (ChainData)o;
            int thisId = this.getHolderId();
            int thatId = chainData.getHolderId();
            if (thisId != 0 && thisId == thatId) {
                return true;
            }
            return this.unresolvedChainData != null && this.unresolvedChainData.equals(chainData.unresolvedChainData);
        }

        public void kill() {
            if (this.isDead) {
                ConnectibleChains.LOGGER.warn("Stop! Stop! {} is already dead!", (Object)this);
            }
            this.isDead = true;
        }

        public boolean isAlive() {
            return !this.isDead;
        }

        public int hashCode() {
            return Objects.hash(this.getHolderId());
        }

        public String toString() {
            return "ChainData{collisionStorage=" + String.valueOf(this.collisionStorage) + ", unresolvedChainData=" + String.valueOf(this.unresolvedChainData) + ", sourceItem=" + String.valueOf(this.sourceItem) + ", unresolvedChainHolderId=" + this.unresolvedChainHolderId + ", chainHolder=" + String.valueOf(this.chainHolder) + "}";
        }
    }
}

